;**********************************************************************
;                                                                     *
;    Filename:      runeng.asm                                        *
;    Date:          2.09.99                                           *
;    File Version:  1.01                                              *
;                                                                     *
;    Author:        Dmitry Salikoff                                   *
;    Company:       My flat                                           *
;                                                                     * 
;                                                                     *
;**********************************************************************
;                                                                     *
;    Files required:                                                  *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes:                                                           *
;                                                                     *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************

	list      p=17c756            ; list directive to define processor
	#include <p17c756.inc>        ; processor specific variable definitions
	#include <ports.inc>	      ;  
	#include <macros.asm>
	
	__CONFIG   _XT_OSC & _WDT_OFF & _MC_MODE & _BODEN_ON

;*******    RAM EQUATES
TEMP_WREG       EQU     0x1A
TEMP_ALUSTA     EQU     0x1B
TEMP_BSR        EQU     0x1C
TEMP_PCLATH     EQU     0x1D
AARGB0		EQU	0x1E		;   
AARGB1		EQU	0x1F

	CBLOCK 0x50
;     -------------------------------------------------------
		MSD, LSD		;     
					;
		CHAR			;      
		DELAY1, DELAY2, DELAY3	;  
		SRTEMP,	SRCOUNT		;    
		SRDIG_H, SRDIG_L, SRDIG_E		
		SRR0, SRR1, SRR2
		TMP, TEMP
;    ------------------------------------------------------------------------
		tmp_key			;    
		cnt_tmr0		;       
		cnt_tmr1
		cnt_tmr2
		cnt_body		;     
		cnt_time		;     (-  )
		cnt_time1
		cnt_pop			;    
		spool			;      
		tmp_ned			;    
		tmp_fsr			;    
		cnt_tmp			;   
		cnt_return0		;      
		cnt_return1		;
		cnt_return2
		tmp_izm			;     
		cnt_t0			;     
		cnt_t1
		cnt_t2
		cnt_t3
;   -----------------------------------------------------------------------------------
		mount			; 
		day			; 
		day_ned			;  
		hour			; 
		min			; 
		sec			; 
;   -------------------------------------------------------------------------------
		flag1, hour1, min1	;  1
		flag2, hour2, min2	;  2
		flag3, hour3, min3	;  3
					;     flagx:
					; (1 - , 0 -  )
					; 0 -   
					; 1 -  
					; 2 -  
					; 3 -   
					
	endc

;     flagx
allday		equ 0			;   
oneday		equ 1			;  
everyday	equ 2			;  
workday		equ 3			;   






;**********************************************************************
                ORG    0x000
;you may want to clear PCLATH and ALUSTA registers here      
                goto   start	


;************   INT PIN INTERRUPT VECTOR
                ORG    0x008
                PUSH              ;save specific registers
                movlw  high  intpin_isr_handler
                movwf  PCLATH
                movlw  low   intpin_isr_handler
                movwf  PCL
;************   TIMER0 INTERRUPT VECTOR
                ORG    0x010
                PUSH	          ;save specific registers
                movlw  high  timer0_isr_handler
                movwf  PCLATH
                movlw  low   timer0_isr_handler
                movwf  PCL
;************   T0CKI PIN INTERRUPT VECTOR
                ORG    0x018
                PUSH              ;save specific registers
                movlw  high  t0cki_isr_handler
                movwf  PCLATH
                movlw  low   t0cki_isr_handler
                movwf  PCL
;************   PERIPHERAL INTERRUPT VECTOR
                ORG		0x020
                PUSH              ;save specific registers
; isr code can go here or be located as a call subroutine elsewhere
                POP               ;restore specific registers
                retfie            ;return from interrupt
;****** INT PIN INTERRUPT SERVICE HANDLER
intpin_isr_handler
	        POP               ;restore registers
                retfie            ;return from interrupt
;****** TIMER0 INTERRUPT SERVICE HANDLER
timer0_isr_handler
		movlw high (0xFFFF - period + per_pop)	; . 
		movwf TMR0H
		movlw low (0xFFFF - period + per_pop)
		movwf TMR0L
		bcf INTSTA,T0IF
		banksel sec
		incf sec,f
		movlw .60
		cpfseq sec
		goto clock1
		clrf sec,f
		incf min,f
		movlw .60
		cpfseq min
		goto clock1	
		clrf min,f
		incf hour,f
		movlw .24
		cpfseq hour
		goto clock1
		clrf hour,f
		incf day_ned,f
		movlw .7
		cpfseq day_ned
		goto clock1
		clrf day_ned,f	 
clock1
                POP               ;restore registers
                retfie            ;return from interrupt
period		equ .31250		;  
per_pop		equ .2			;       




;****** T0CKI INTERRUPT SERVICE HANDLER
t0cki_isr_handler
;isr code goes here
                POP               ;restore registers
                retfie            ;return from interrupt





 include <lcd.asm>
 include <nadpis.asm>
 include <delay.asm>
 include <clock.asm>

; ====================   ==============================
lighter
		banksel pphoto
		btfss pphoto, photo
		goto lighter1
		banksel plight
		bsf plight,light
		goto lighter2
lighter1
		banksel plight
		bcf plight,light
lighter2	return

; ======================     ==========
key_snd
		
		return

; ===================    =======================
;       
;     1
;   - 0,2 
;        
izmer
		banksel TMR1		;  
		clrf TMR1,f
		banksel PIR1		;   
		bcf PIR1,TMR1IF
		banksel TCON2		;  
		bsf TCON2,TMR1ON

		banksel cnt_tmr0	;   
		movlw .50
		movwf cnt_tmr0
izmer1		movlw .250
		movwf cnt_tmr1
izmer2		movlw .65
		movwf cnt_tmr2
izmer3		decfsz cnt_tmr2,f
		goto izmer3
		decfsz cnt_tmr1,f
		goto izmer2
		decfsz cnt_tmr0,f
		goto izmer1
			
		banksel TCON2		;  
		bcf TCON2,TMR1ON
		return

; ===================     () ===========
snd_no		movlw .2			;    
		call delay_snd
		movlw .1
		call delay_sec
		movlw .2
		call delay_snd
		movlw .1
		call delay_sec
		movlw .4
		call delay_snd
		return
; ============      ==============
snd_key
		pisk 1
		pause 3
		return
; ========================      =================
;        SRDIG_L 
lcd_bin
		banksel SRDIG_H
		clrf SRDIG_H
		call B2_BCD
		banksel SRR2
		swapf SRR2,w
		andlw 0x0F
		addlw 30
		call send_char		;   
		banksel SRR2
		movlw 0x0F
		andwf SRR2,w
		addlw 30
		call send_char		;   
		return
	

;************************************************************************
;****************************	MAIN PROGRAM   **************************
;************************************************************************
;************************************************************************
;************************************************************************
start		
;     --------------------------------------------




;  
;     1 -          0 - 
; PORT A
	BANKSEL PORTA			; select bank 0
	CLRF PORTA
	BSF PORTA, RBPU
 
; PORT B
	banksel PORTB
	CLRF PORTB
	MOVLW PB_NAPR
	MOVWF DDRB
	nop
	nop
	starter_off
	nop
	s_lock_on
	nop
	bcf pvalet,valet
	nop


; PORT C
	banksel PORTC
	MOVLB 1
	CLRF PORTC
	MOVLW PC_NAPR
	MOVWF DDRC

; PORT D
	MOVLB 1
	CLRF PORTD
	MOVLW PD_NAPR
	MOVWF DDRD

; PORT E
	MOVLB 1
	CLRF PORTE
	MOVLW PE_NAPR
	MOVWF DDRE

; PORT F
; Upon reset the entire port is automatically configured as analog inputs
;  
	MOVLW B'01101110'		; Fosc/32
					; ADFM=1
					; AD REFERENCE Vref
					;  5,6,7   
	banksel ADCON1
	MOVPF WREG,ADCON1
	CLRF PORTF
	MOVLW PF_NAPR	
	MOVWF DDRF

; PORT G
; Upon reset the entire port is automatically configured as analog inputs
	MOVLW B'01101110'		; Configure PORTG as digital
	MOVPF WREG,ADCON1
	CLRF PORTG
	MOVLW PG_NAPR		; 1 - 
	MOVWF DDRG





;      	
	MOVLW HIGH (LCD_INIT)
	MOVPF WREG,PCLATH
	LCALL LCD_INIT
	MOVLW HIGH (SEND_CMD)
	MOVPF WREG,PCLATH
;                    DCB 
	MOVLW B'00001100'		; D=1  
					; C=1  
					; B=1    

	LCALL SEND_CMD
;		   DNF
;	MOVLW B'00111100'		; D=1 8-  
					; N=1 2 
					; F=1  
;	CALL SEND_CMD

	MOVLW HIGH (SEND_CMD)
	MOVPF WREG,PCLATH
	MOVLW CLR_DISP	
	LCALL SEND_CMD

		banksel plight		;   
		bsf plight,light	
		nop
		starter_off
		nop
		nop
		s_lock_on

; check LCD module with output text
;     
QQQQQ1
	MOVLW CLR_DISP
	MOVLW HIGH (SEND_CMD)
	MOVPF WREG,PCLATH
	CALL SEND_CMD 

	MOVLW HIGH FIRMA1		;  
	MOVWF TBLPTRH
	MOVLW LOW FIRMA1
	MOVWF TBLPTRL
	CALL SEND_LINE
	MOVLW HIGH FIRMA2		;  
	MOVWF TBLPTRH
	MOVLW LOW FIRMA2
	MOVWF TBLPTRL
	CALL SEND_LINE

;      ***************************
init_bk
		banksel sec		;   
		clrf sec,f
		clrf min,f
		clrf hour,f
		incf hour,f
		clrf day_ned,f
		clrf day,f
		clrf flag1,f
		clrf flag2,f
		clrf flag3,f
		clrf hour1,f
		clrf hour2,f
		clrf hour3,f
		clrf min1,f
		clrf min2,f
		clrf min3,f
		bsf flag1,oneday
		bsf flag2,oneday
		bsf flag3,oneday
		starter_off		;   
		s_lock_off
		ign_off
		per_off
	
		
;      *******************************
		clrf TMR0L,f
		clrf TMR0H,f
		movlw b'00101110'	;       1:128
		movwf T0STA
		bcf INTSTA,T0IF		;  
		bcf CPUSTA, GLINTD	;   
		bsf INTSTA,T0IE		;    

;      *****************************
		banksel PR1		;   
		movlw 0xFF
		movwf PR1
		movwf PR2
		banksel TCON1		;    8-  
		bcf TCON1,T16
		bsf TCON1,TMR1CS	;  1    
		bsf TCON1,TMR2CS	;  2    
		


		movlw .10
		call delay_sec
		movlw .2		;       !
		call delay_snd
		movlw .1
		call delay_sec
		movlw .3
		call delay_snd
		movlw .1
		call selay_sec
		movlw .6
		call delay_snd
		movlw .10
		call delay_sec

		lcd_clr
		banksel plight		;   
		bcf plight,light	





; ----------------------------------------------------------------------------
;    ------------------------------------------------
; ----------------------------------------------------------------------------
wait_begin_snd
		call snd_key
wait_begin	
		lcd_clr
		movlw HIGH txt_wait		; enter code
		movwf TBLPTRH
		movlw LOW txt_wait
		movwf TBLPTRL
		call SEND_LINE
		starter_off
		ign_off
		per_off
wait
;		call lighter			;  ,  ...
		light_off
		call time
		line_one txt_tmr		;    
		banksel flag1
		movlw 0x2D
		btfsc flag1,allday
		movlw '1'
		call SEND_CHAR
		banksel flag1
		movlw 0x2D
		btfsc flag2,allday
		movlw '2'
		call SEND_CHAR
		banksel flag1
		movlw 0x2D
		btfsc flag3,allday
		movlw '3'
		call SEND_CHAR
		banksel pign
		btfss pign,ign			;   
		goto wait1
		s_lock_on			;   
		goto wait2
wait1
		s_lock_off			;   
wait2


;    -------------------------------------------------
		banksel pign			;   
		btfsc pign,ign			;   
		goto alarm_end			;    
		
	
		banksel palarm			;         ?
		btfss palarm,alarm
		goto al_start			;  


alarm1a
		banksel flag1	
		movlw 3				;  	
		movwf cnt_tmp
		movlw low flag1			;    
		movwf FSR0
alarm1		
		incf FSR0,f			;  
		banksel flag1
		movfp INDF0,WREG
		cpfseq hour
		goto alarm3 		
		incf FSR0,f			;  
		movfp INDF0,WREG
		cpfseq min
		goto alarm4
		movlw .11			;  
		subwf sec,w
		btfsc ALUSTA,C
		goto alarm4
		pisk 1
		pause 3
		decf FSR0,f
		decf FSR0,f
		banksel flag1
		btfss INDF0,allday		;    
		goto alarm2
		btfsc INDF0,everyday		;  ?
		goto sstart_alarm		; .....
		btfss INDF0,oneday 
		goto alarm5
		bcf INDF0,oneday		;   
		bcf INDF0,allday		;   
		goto sstart_alarm		;  .....
alarm5		btfss INDF0,workday		;    
		goto alarm2
		movlw 5				;   
		cpfseq day_ned
		goto alarm6
		goto alarm2
alarm6		movlw 6				;   
		cpfseq day_ned
		goto sstart_alarm		; .....		
alarm2		incf FSR0,f
alarm3		incf FSR0,f
alarm4		incf FSR0,f		
		decfsz cnt_tmp,f
		goto alarm1
alarm_end		  	






		banksel pkey			;     
		btfss pkey,key_set
		call snd_no
		btfss pkey,key_stop
		call snd_no
		banksel pkey
		btfss pkey,key_ch
		goto bud		

		banksel tmp_key			;     
		clrf tmp_key,f
wait3
		banksel pkey
		btfsc pkey,key_start		
		goto wait_end
		banksel tmp_key
		decfsz tmp_key,f
		goto wait3
		movlw .15
		call delay_snd

		banksel tmp_key		
		clrf tmp_key,f
wait4
		banksel pkey
		btfss pkey,key_start
		goto wait_end1
		btfss pkey,key_set
		goto wait_end1
		btfss pkey,key_ch
		goto wait_end1
		btfsc pkey,key_stop		
		goto wait_end1
		banksel tmp_key
		decfsz tmp_key,f
		goto wait4
		movlw .5
		call delay_snd

		movlw HIGH txt_ena		; RUN ENABLE
		movwf TBLPTRH
		movlw LOW txt_ena
		movwf TBLPTRL
		call SEND_LINE
		movlw .3
		call delay_sec
		movlw .20
		call delay_snd
		banksel pkey			;     
		btfss pkey,key_start
		goto wait_end1
		btfss pkey,key_set
		goto wait_end1
		btfss pkey,key_ch
		goto wait_end1
		btfss pkey,key_stop		
		goto wait_end1
		goto mmm



wait_end1	movlw .10
		call delay_snd
		movlw .3
		call delay_sec
		movlw .2
		call delay_snd
wait_end
		goto wait



; ---------------------------------------------------------------------------
;     -------------------------------------------
; ---------------------------------------------------------------------------
bud
		s_lock_on			;     
		light_on
		call snd_key			;  1
		lcd_clr
bud2
		line_one txt_bud1
		banksel pkey			;  
		btfss pkey,key_ch
		goto bud1
		btfsc pkey,key_set
		goto bud2
		call snd_key
		movlw low flag1
		movwf FSR0
		goto bud40
		
		
bud1
		s_lock_on			;     
		call snd_key			;  2
		lcd_clr
bud3
		line_one txt_bud2
		banksel pkey			;  
		btfss pkey,key_ch
		goto bud4
		btfsc pkey,key_set
		goto bud3
		call snd_key
		movlw low flag2
		movwf FSR0
		goto bud40


		
bud4
		s_lock_on			;     
		call snd_key			;  3
		lcd_clr
bud5
		line_one txt_bud3
		banksel pkey			;  
		btfss pkey,key_ch
		goto bud6
		btfsc pkey,key_set
		goto bud5
		call snd_key
		movlw low flag3
		movwf FSR0
		goto bud40
	


		
bud6
		s_lock_on			;     
		call snd_key			;  
		lcd_clr
bud7
		line_one txt_bud4
		banksel pkey			;  
		btfss pkey,key_ch
		goto bud8
		btfsc pkey,key_set
		goto bud7
bud34
		call snd_key			;     
		line_one txt_com1
bud30
		banksel flag1 
		bcf flag1,allday 
		bcf flag2,allday
		bcf flag3,allday
		banksel pkey
		btfss pkey,key_set
		goto wait_begin_snd
		btfsc pkey,key_ch
		goto bud30

		call snd_key			;    
		line_one txt_com2
bud31
		banksel flag1 
		bsf flag1,allday 
		bcf flag2,allday
		bcf flag3,allday
		banksel pkey
		btfss pkey,key_set
		goto wait_begin_snd
		btfsc pkey,key_ch
		goto bud31

		call snd_key			;     	
		line_one txt_com3
bud32
		banksel flag1 
		bsf flag1,allday 
		bsf flag2,allday
		bcf flag3,allday
		banksel pkey
		btfss pkey,key_set
		goto wait_begin_snd
		btfsc pkey,key_ch
		goto bud32

		call snd_key			;   
		line_one txt_com4
bud33
		banksel flag1 
		bsf flag1,allday 
		bsf flag2,allday
		bsf flag3,allday
		banksel pkey
		btfss pkey,key_set
		goto wait_begin_snd
		btfsc pkey,key_ch
		goto bud33
		goto bud34
			

		
bud8
		s_lock_on			;     
		call snd_key			;  
		lcd_clr
bud9
		line_one txt_bud5
		banksel pkey			;  
		btfss pkey,key_ch
		goto bud10
		btfsc pkey,key_set
		goto bud9
		call snd_key
bud14
		banksel cnt_body		;  
		incf cnt_body,f
		line_one vremya
		movlw ' '
		call send_char
		banksel cnt_body
		btfss cnt_body,0
		goto bud11
		movlw ' '
		call send_char
		movlw ' '
		call send_char
		goto bud12		
bud11
		banksel hour
		movfp hour,WREG
		movwf SRDIG_L
		call lcd_bin
bud12
		movlw ' '
		banksel sec
		btfss sec,0
		movlw ':'
		call send_char		; 
		banksel min
		movfp min,WREG
		movwf SRDIG_L
		call lcd_bin
		movlw 3
		call delay_sec
		banksel pkey
		btfss pkey,key_set
		goto bud13
		btfsc pkey,key_ch
		goto bud14
;		call snd_key
		pisk 1
		pause 1
		banksel hour
		incf hour,f
		movlw .25
		cpfseq hour
		goto bud14
		clrf hour,f
		goto bud14

bud13
		call snd_key
bud15
		banksel cnt_body		;  
		incf cnt_body,f
		line_one vremya
		movlw ' '
		call send_char
		banksel hour
		movfp hour,WREG
		movwf SRDIG_L
		call lcd_bin
		movlw ' '
		banksel sec
		btfss sec,0
		movlw ':'
		call send_char			; 
		banksel cnt_body
		btfss cnt_body,0
		goto bud16
		movlw ' '
		call send_char
		movlw ' '
		call send_char
		goto bud17
bud16
		banksel min
		movfp min,WREG
		movwf SRDIG_L
		call lcd_bin
bud17		movlw 3
		call delay_sec
		banksel pkey
		btfss pkey,key_set
		goto bud20
		btfsc pkey,key_ch
		goto bud15
;		call snd_key
		pisk 1
		pause 1
		banksel min
		incf min,f
		movlw .60
		cpfseq min
		goto bud15
		clrf min,f
		goto bud15
bud20
		call snd_key
bud18						;   
		banksel day_ned
		incf day_ned,w
		movwf tmp_ned
		decfsz tmp_ned,f
		goto time2a
		line_one txt_day1
		goto time_enda
time2a		decfsz tmp_ned,f
		goto time3a
		line_one txt_day2
		goto time_enda
time3a		decfsz tmp_ned,f
		goto time4a
		line_one txt_day3
		goto time_enda
time4a		decfsz tmp_ned,f
		goto time5a
		line_one txt_day4
		goto time_enda
time5a		decfsz tmp_ned,f
		goto time6a
		line_one txt_day5
		goto time_enda
time6a		decfsz tmp_ned,f
		goto time7a
		line_one txt_day6
		goto time_enda
time7a		line_one txt_day7
time_enda
		movlw 3
		call delay_sec
		banksel pkey
		btfss pkey,key_set
		goto wait_begin_snd
		btfsc pkey,key_ch
		goto bud18
		call snd_key
		banksel day_ned
		incf day_ned,f
		movlw .7
		cpfseq day_ned
		goto bud18
		clrf day_ned,f
		goto bud18

bud10		
		call snd_key			;    
		goto wait_begin









bud40						;  
		incf FSR0,f			;   
bud41		movlw 0xC7			;   
		call SEND_CMD
		banksel cnt_body
		incf cnt_body,f
		btfss cnt_body,0
		goto bud42
		movlw ' '
		call SEND_CHAR
		movlw ' '
		call SEND_CHAR
		goto bud43
bud42		movfp INDF0,WREG
		movwf SRDIG_L
		movpf FSR0,tmp_fsr
		call lcd_bin
		movfp tmp_fsr,FSR0
bud43		movlw ':'
		call SEND_CHAR
		banksel min1
		incf FSR0,f
		movfp INDF0,WREG
		movwf SRDIG_L
		decf FSR0,f
		movpf FSR0,tmp_fsr
		call lcd_bin
		movfp tmp_fsr,FSR0
		decf FSR0,f			;   
		btfss INDF0,oneday
		goto bud44
		line_one txt_tmr1
		goto bud45
bud44		btfss INDF0,everyday
		goto bud46
		line_one txt_tmr2
		goto bud45
bud46
		line_one txt_tmr3
bud45		incf FSR0,f
		pause 3
		banksel pkey
		btfss pkey,key_set
		goto bud50a
		btfsc pkey,key_ch
		goto bud41
		pisk 1
		pause 1
		banksel hour1
		incf INDF0,f
		movlw .24
		cpfseq INDF0
		goto bud41
		clrf INDF0,f
		goto bud41 
		 

bud50a
		call snd_key
bud50
;		incf FSR0,f			;   
bud51		movlw 0xC7			;   
		call SEND_CMD
		movfp INDF0,WREG
		movwf SRDIG_L
		movpf FSR0,tmp_fsr
		call lcd_bin
		movfp tmp_fsr,FSR0
		movlw ':'
		call SEND_CHAR
		banksel cnt_body
		incf cnt_body,f
		btfss cnt_body,0
		goto bud52
		movlw ' '
		call SEND_CHAR
		movlw ' '
		call SEND_CHAR
		goto bud53
bud52
		banksel min1
		incf FSR0,f
		movfp INDF0,WREG
		movwf SRDIG_L
		decf FSR0,f
		movpf FSR0,tmp_fsr
		call lcd_bin
		movfp tmp_fsr,FSR0
bud53		decf FSR0,f			;   
		btfss INDF0,oneday
		goto bud54
		line_one txt_tmr1
		goto bud55
bud54		btfss INDF0,everyday
		goto bud56
		line_one txt_tmr2
		goto bud55
bud56		line_one txt_tmr3
bud55		incf FSR0,f
		pause 3
		banksel pkey
		btfss pkey,key_set
		goto bud60a
		btfsc pkey,key_ch
		goto bud51
		pisk 1
		pause 1
		banksel hour1
		incf FSR0,f
		incf INDF0,f
		movlw .60
		cpfseq INDF0
		goto bud51a
		clrf INDF0,f
bud51a		decf FSR0,f
		goto bud51 
		 
bud60a
		call snd_key
bud60
bud61		movlw 0xC7			;   
		call SEND_CMD
		movfp INDF0,WREG
		movwf SRDIG_L
		movpf FSR0,tmp_fsr
		call lcd_bin
		movfp tmp_fsr,FSR0
		movlw ':'
		call SEND_CHAR
		banksel min1
		incf FSR0,f
		movfp INDF0,WREG
		movwf SRDIG_L
		decf FSR0,f
		movpf FSR0,tmp_fsr
		call lcd_bin
		movfp tmp_fsr,FSR0
bud63		decf FSR0,f			;   
		banksel cnt_body
		incf cnt_body,f
		btfss cnt_body,0
		goto bud62		
		btfss INDF0,oneday
		goto bud64
		line_one txt_tmr1
		goto bud65
bud64		btfss INDF0,everyday
		goto bud66
		line_one txt_tmr2
		goto bud65
bud66		line_one txt_tmr3
		goto bud65
bud62		
		line_one txt_tmr4
bud65		incf FSR0,f
		pause 3
		banksel pkey
		btfss pkey,key_set
		goto wait_begin_snd
		btfsc pkey,key_ch
		goto bud61
		call snd_key
		banksel hour1
		decf FSR0,f
		btfss INDF0,oneday
		goto bud70
		bcf INDF0,oneday
		bsf INDF0,everyday
		goto bud61a
bud70		btfss INDF0,everyday
		goto bud71
		bcf INDF0,everyday
		bsf INDF0,workday
		goto bud61a
bud71		bcf INDF0,workday
		bsf INDF0,oneday
bud61a		incf FSR0,f
		goto bud61 
		 

; ---------------------------------------------------------------------------
;   ! ------------------------------------------------
; ---------------------------------------------------------------------------
;  :   -     ()
;  ,   ,   .
;    0,        .
;  ,   ,     ,  
; ,  no...
;   ,       
; ( 10 )
mmm
		lcd_clr
		banksel cnt_return0
		clrf cnt_return0,f
		clrf cnt_return1,f
		clrf cnt_return2,f
		per_off
mmm1
		banksel TMR1
		tstfsz TMR1
		goto mmm6s
		line_one txt_mmm		; run enable
		goto mmm6d
mmm6s
		line_one txt_run
mmm6d

		banksel cnt_body
		incf cnt_body,f			;   
		call lighter
		call time

		banksel pkey			;      
		btfsc pkey,key_stop
		goto mmm2
mmm3		call snd_no
		goto wait_begin

mmm2
		nop
		call izmer			;   
		banksel TMR1
		banksel cnt_body		;     
		btfsc cnt_body,3
		movpf TMR1,tmp_izm
		nop
		banksel cnt_body		;     
		btfss cnt_body,3		;   
		goto mmm4
		btfss cnt_body,2
		goto mmm4
		movlw HIGH txt_tach		; tach
		movwf TBLPTRH
		movlw LOW txt_tach
		movwf TBLPTRL
		call SEND_LINE
		goto mmm5
mmm4
		banksel TMR1
		tstfsz TMR1
		goto mmm6
		movlw HIGH txt_0		;  
		movwf TBLPTRH
		movlw LOW txt_0
		movwf TBLPTRL
		call SEND_LINE
		s_lock_off			;   
		goto mmm5
mmm6		
		banksel TMR1			;   
		movlw .4			;  , ,      ~600,
		cpfsgt TMR1			;    " "?
		goto mmm6r
		s_lock_on
mmm6r		movfp tmp_izm,WREG		;   
		mullw .120	
		banksel SRDIG_H			;    
		movpf PRODL,SRDIG_L
		movpf PRODH,SRDIG_H
		call B2_BCD
		movlw 0xD0			;  4  
		call SEND_CMD
		movlw 0xF0
		andwf SRR1,w
		swapf WREG,w
		addlw 0x30 
		call SEND_CHAR
		movlw 0x0F
		andwf SRR1,w
		addlw 0x30
		call SEND_CHAR
		movlw 0xF0
		andwf SRR2,w
		swapf WREG,w
		addlw 0x30 
		call SEND_CHAR
		movlw 0x0F
		andwf SRR2,w
		addlw 0x30
		call SEND_CHAR
;		s_lock_off			;    
mmm5
		banksel TMR1			;      ?
		tstfsz TMR1			; (   )	
		goto mmm9
		banksel tmp_key			;   
		clrf tmp_key,f
mmm7		
		banksel pkey
		btfsc pkey,key_start
		goto mmm8
		banksel tmp_key
		decfsz tmp_key,f
		goto mmm7			; .....
		line_one txt_sss		;  
		movlw .6
		call delay_snd	
		movlw .9
		call delay_sec
;		banksel pign			;   
;		btfsc pign,ign			;  ,    
		goto sstart
		movlw .1
		call delay_sec
		movlw .2
		call delay_snd
		movlw .1
		call delay_sec
		movlw .2
		call delay_snd
		goto mmm9			;  
mmm8		
		banksel palarm			;         ?
		btfsc palarm,alarm
		goto mmm9
al_start	movlw HIGH txt_ala		;  
		movwf TBLPTRH
		movlw LOW txt_ala
		movwf TBLPTRL
		call SEND_LINE
		movlw .3
		call delay_snd
		movlw .10
		call delay_sec
;		banksel pign			;   ?
;		btfss pign,ign
		goto sstart
mmm9
		banksel pkey
		btfss pkey,key_start
		call snd_no 
mmm_end	
		banksel cnt_return0		;      
		banksel pign			;   
		btfss pign,ign
		goto mmm_return1
		clrf cnt_return0,f
		clrf cnt_return1,f
		clrf cnt_return2,f
mmm_return1	incfsz cnt_return0,f
		goto mmm_return2
		incfsz cnt_return1,f
		goto mmm_return2
		incfsz cnt_return2,f
		goto mmm_return2
		goto mmm3			;      
mmm_return2					;    (46500 )
		movlw 0x2			;  10 ,  
		cpfseq cnt_return2		; 1  - 0,125 
		goto mmm_end1
		movlw 0x65
		cpfseq cnt_return1
		goto mmm_end1
		movlw 0x0
		cpfseq cnt_return0
		goto mmm_end1
		goto mmm3			; ...
mmm_end1
		goto mmm1




; ---------------------------------------------------------------------------
;    -----------------------------------------------
; ---------------------------------------------------------------------------
sstart_alarm
		pisk 1
		pause 2
		pisk 2
		pause 2
		pisk 4
		pause 2
		pisk 8
		pause 2
		pisk .16
		pause 2
sstart
		lcd_clr
		banksel cnt_pop			;   
		movlw .3
		movwf cnt_pop
sstart1
		banksel pkey			;    
		btfsc pkey,key_stop
		goto sstart2
		call snd_no
		goto mmm
sstart2
		movlw HIGH txt_sta1		;   
		movwf TBLPTRH
		movlw LOW txt_sta1
		movwf TBLPTRL
		call SEND_LINE
		s_lock_on			;    
		ign_on				;   
		movlw .6
		call delay_sec
		bsf pvalet,valet		;   
		movlw .60
		call delay_sec
		bcf pvalet,valet
		movlw 2
		call delay_sec


		banksel pkey			;    
		btfsc pkey,key_stop
		goto sstart3
		call snd_no
		goto mmm
sstart3		movlw .8
		call delay_sec
		banksel pkey			;    
		btfsc pkey,key_stop
		goto sstart4
		call snd_no
		goto mmm



; ---------------------------------------------------------------------------
;     -----------------------------------------------
; ---------------------------------------------------------------------------
;      5 
;   - ,   - 
;     - 2  ( )
sstart4		starter_on		;  
		movlw HIGH txt_sta2	;   
		movwf TBLPTRH
		movlw LOW txt_sta2
		movwf TBLPTRL
		call SEND_LINE
spin
		banksel cnt_time
		movlw .5		;     ()
		movwf cnt_time	
spin1
		banksel TMR1		;  
		clrf TMR1,f
		banksel PIR1		;   
		bcf PIR1,TMR1IF
		banksel TCON2		;  
		bsf TCON2,TMR1ON
		banksel cnt_tmr0	;   
		movlw .15
		movwf cnt_tmr0
izmer11		movlw .250
		movwf cnt_tmr1
izmer12		movlw .65
		movwf cnt_tmr2
izmer13		decfsz cnt_tmr2,f
		goto izmer13
		banksel TMR1		;     
		movfp TMR1,WREG
		sublw 2
		btfss ALUSTA,C
		goto dada		; !
		banksel cnt_tmr1 
		decfsz cnt_tmr1,f
		goto izmer12
		decfsz cnt_tmr0,f
		goto izmer11			
		banksel TCON2		;  
		bcf TCON2,TMR1ON

		banksel pkey		;   (  )
		btfss pkey,key_start
		goto mmm
		btfss pkey,key_stop
		goto mmm
		btfss pkey,key_set
		goto mmm
		btfss pkey,key_ch
		goto mmm
		banksel palarm		;   
		btfss palarm,alarm
		goto mmm

		banksel cnt_time	;      
		decfsz cnt_time,f
		goto spin1 


; ---------------------------------------------------------------------------
;    ----------------------------------------------------------
; ---------------------------------------------------------------------------
;  10    ,  
nono
		starter_off
		lcd_clr
		movlw HIGH txt_no1	;  
		movwf TBLPTRH
		movlw LOW txt_no1
		movwf TBLPTRL
		call SEND_LINE
		banksel cnt_time		
		movlw .50
		movwf cnt_time
		ign_off
		s_lock_off

nono1		call izmer
		banksel pkey
		btfss pkey,key_stop
		goto ttt1
		banksel palarm
		btfss palarm,alarm
		goto ttt2
		banksel TMR1
		tstfsz TMR1
		goto ttt3
		banksel cnt_time
		decfsz cnt_time,f
		goto nono1
		decfsz cnt_pop,f
		goto sstart1		;  
		goto wait_begin_snd

ttt1		nop
ttt2		nop
ttt3   		nop
		goto mmm	

; ---------------------------------------------------------------------------
;  !!! !  ---------------------------------------------
; ---------------------------------------------------------------------------
;    - 7 ,  !

time_work	equ .60			;     
time_per_on	equ time_work - .15	;      


dada
		starter_off
		lcd_clr
		movlw HIGH txt_da1	;  
		movwf TBLPTRH
		movlw LOW txt_da1
		movwf TBLPTRL
		call SEND_LINE
		movlw .50
		call delay_sec		;   
		banksel cnt_time		
		movlw time_work
		movwf cnt_time		;  
dada4		movlw .40
		movwf cnt_time1

dada2		
		banksel cnt_body
		incf cnt_body,f
		call izmer 
		banksel TMR1
		banksel cnt_body		;     
		btfsc cnt_body,3		;   
		movpf TMR1,tmp_izm

		call time
		banksel pkey			;  ?
		btfss pkey,key_stop
		goto wait_begin
		banksel palarm			;    ?
		btfss palarm,alarm
		goto wait_begin

		banksel TMR1			;    0
		tstfsz TMR1
		goto dada1
		goto nono
dada1		movlw .15
		subwf TMR1,w			;    
		btfsc ALUSTA,C
		goto dest1


		banksel cnt_body		;     
		btfss cnt_body,3		;   
		goto mmm4m
		btfss cnt_body,2
		goto mmm4m
		line_one txt_tach		; tach
		goto mmm5m
mmm4m
		banksel tmp_izm			;   
		movfp tmp_izm,WREG		;   
		mullw .120	
		banksel SRDIG_H			;    
		movpf PRODL,SRDIG_L
		movpf PRODH,SRDIG_H
		call B2_BCD
		movlw 0xD0			;  4  
		call SEND_CMD
		movlw 0xF0
		andwf SRR1,w
		swapf WREG,w
		addlw 0x30 
		call SEND_CHAR
		movlw 0x0F
		andwf SRR1,w
		addlw 0x30
		call SEND_CHAR
		movlw 0xF0
		andwf SRR2,w
		swapf WREG,w
		addlw 0x30 
		call SEND_CHAR
		movlw 0x0F
		andwf SRR2,w
		addlw 0x30
		call SEND_CHAR
mmm5m


 		banksel cnt_time
		decfsz cnt_time1,f
		goto dada2
		movlw time_per_on		;     
		nop
		banksel cnt_time
		subwf cnt_time,w
		btfsc ALUSTA,C
		goto mmm5t
		per_on
mmm5t		nop
		nop
		banksel SRDIG_H			;     
		movfp cnt_time,WREG
		movwf SRDIG_L
		clrf SRDIG_H,f
		call B2_BCD
		movlw 0x92			;  2  
		call SEND_CMD
		movlw 0xF0
		andwf SRR2,w
		swapf WREG,w
		addlw 0x30 
		call SEND_CHAR
		movlw 0x0F
		andwf SRR2,w
		addlw 0x30
		call SEND_CHAR
		

		decfsz cnt_time,f
		goto dada4
		goto wait_begin


;     
dest1
		lcd_clr
		line_one txt_dest1
		banksel cnt_tmp
		movlw .10
		movwf cnt_tmp
dest2
		line_one txt_dest2
		banksel cnt_tmp
		movfp cnt_tmp,WREG
		movwf SRDIG_L
		clrf SRDIG_H,f
		call B2_BCD
		movlw 0xF0
		andwf SRR2,w
		swapf WREG,w
		addlw 30
		call SEND_CHAR
		movlw 0x0F
		andwf SRR2,w
		addlw 30
		call SEND_CHAR
		pisk 2
		pause 2
		pisk 2
		pause 4
		banksel pkey
		btfss pkey,key_stop
		goto dest3
		banksel cnt_tmp
		decfsz cnt_tmp,f
		goto dest2
dest3
		lcd_clr
		s_lock_on
		starter_off
		ign_off
		per_off
		line_one txt_dest3
		pisk 20
		goto wait_begin





		banksel tmp_ned
		movlw 0x20
		movwf tmp_ned
tttt		movlw 0x80
		call SEND_CMD
		banksel tmp_ned
		movfp tmp_ned,WREG
		call SEND_CHAR
		movlw ' '
		call SEND_CHAR
		banksel tmp_ned
		movfp tmp_ned,WREG
		movwf SRDIG_L
		clrf SRDIG_H
		call B2_BCD
 		movlw 0x0F
		andwf SRR1,w
		addlw 0x30
		call SEND_CHAR
		movlw 0xF0
		andwf SRR2,w
		swapf WREG
		addlw 30H
		call SEND_CHAR
		movlw 0x0F
		andwf SRR2,w
		addlw 0x30
		call SEND_CHAR
		banksel pkey
		btfsc pkey,key_start
		goto tttt
		call snd_key
		banksel tmp_ned
		incf tmp_ned,f
		goto tttt		
		goto mmm


test
		clrf cnt_t0,f
		clrf cnt_t1,f
		clrf cnt_t2,f
		clrf cnt_t3,f

		banksel ptemp
test1		btfsc ptemp,temp	;  0
		goto test1
test2		btfss ptemp,temp	;  1
		goto test2	
		
test3		incfsz cnt_t0,f
		goto test_end
		incfsz cnt_t1,f
		goto test_end
		incfsz cnt_t2,f
		goto test_end
		incf cnt_t3,f
test_end
		btfsc ptemp,temp
		goto test3		
		nop
		nop
		goto test





                END	              ;required directive
